import { Column, Row, Table } from '../Table.types';

const getRandomNumber = (max: number) => Math.floor(Math.random() * max);

const generateCurrencyCell = () => {
  return {
    value: getRandomNumber(10000),
    currency: {
      code: 'rub',
      id: 2,
      name: 'Рубли',
    },
  };
};

const generateCustomViewCell = () => {
  return {
    viewName: 'TicketShortInfo',
    viewData: {
      title: 'НЕИСПОЛНЕНИЕ ЧЕГО ТО ТАМ',
      id: '123123',
      accountName: 'СОВКОМБАНК',
      accountId: '1',
    },
  };
};

const generateLinkCell = () => {
  return { link: 'https://st.yandex-team.ru/CRM-11119', text: { value: 'CRM-11119' } };
};

const generateAccountCell = () => {
  return { id: 111, name: 'Test Account Name', type: 'Клиент' };
};

const generateUserCell = () => {
  return {
    id: 150218,
    name: 'Котеев Лев',
    login: 'lkoteev',
    group: {
      name: 'Группа разработки CRM',
    },
    crm_email: {
      label: 'email',
      value: 'lkoteev@yandex-team.ru',
    },
    position: 'Разработчик',
    crm_position: 'Tier_4_Phone',
    office: 'Москва, БЦ Морозов',
    phones: {
      work: '4586',
    },
  };
};

const generateTagCell = () => {
  return { id: '1', color: 'fc0', name: 'tagName with long name' };
};

const generateTextCell = () => {
  return { value: 'AlmostRandomText' };
};

const generateDigitCell = () => {
  return { value: getRandomNumber(10000) };
};

const generatePercentCell = () => {
  return { value: getRandomNumber(100) };
};

const generateSelectCell = () => {
  return { id: 0, name: '1 месяц' };
};

const generateSuggestCell = () => {
  return { value: { id: 1, name: 'Кострома' } };
};

const generateDiffCell = () => {
  return {
    fieldName: 'Звонок',
    oldValue: '2',
    newValue: '3',
  };
};

const generateButtonCell = (colId = '') => {
  return [
    { id: colId, type: 'Button', data: { type: 'EditButton' } },
    { id: colId, type: 'Button', data: { type: 'RemoveButton' } },
  ];
};

const generateCellByType = (type: string) => {
  const typeToCell = {
    Money: generateCurrencyCell,
    Link: generateLinkCell,
    Text: generateTextCell,
    Digit: generateDigitCell,
    Percent: generatePercentCell,
    Diff: generateDiffCell,
    Button: generateButtonCell,
    Select: generateSelectCell,
    Suggest: generateSuggestCell,
    Tag: generateTagCell,
    CustomView: generateCustomViewCell,
    Account: generateAccountCell,
    User: generateUserCell,
  };
  if (typeof typeToCell[type] === 'function') {
    return typeToCell[type]();
  }
};

const columns: Column[] = [
  {
    id: 'someId1',
    sortable: false,
    title: 'Money',
    type: 'Money',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
    items: [
      {
        code: 'client',
        id: 1,
        name: 'Валюта клиента',
      },
      {
        code: 'rub',
        id: 2,
        name: 'Рубли',
      },
      {
        code: 'byn',
        id: 3,
        name: 'Бел. рубли',
      },
      {
        code: 'kzt',
        id: 4,
        name: 'Тенге',
      },
      {
        code: 'eur',
        id: 5,
        name: 'Евро',
      },
      {
        code: 'usd',
        id: 6,
        name: 'Доллары',
      },
      {
        code: 'chf',
        id: 7,
        name: 'Швейц. франки',
      },
      {
        code: 'uzs',
        id: 8,
        name: 'Сум',
      },
    ],
  },
  {
    id: 'someId2',
    sortable: false,
    title: 'Link',
    type: 'Link',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId3',
    sortable: false,
    title: 'Text',
    type: 'Text',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId4',
    sortable: false,
    title: 'Diff',
    type: 'Diff',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId5',
    sortable: false,
    title: 'Percent',
    type: 'Percent',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId6',
    sortable: false,
    title: 'Digit',
    type: 'Digit',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId7',
    sortable: false,
    title: 'Select',
    type: 'Select',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
    items: [
      {
        id: '0',
        name: '1 месяц',
      },
      {
        id: '1',
        name: '3 месяца',
      },
      {
        id: '2',
        name: '6 месяцев',
      },
      {
        id: '3',
        name: '9 месяцев',
      },
    ],
  },
  {
    id: 'someId8',
    sortable: false,
    title: 'Suggest',
    type: 'Suggest',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
    items: [
      {
        id: '0',
        name: 'Воронеж',
      },
      {
        id: '1',
        name: 'Кострома',
      },
    ],
  },
  {
    id: 'someId9',
    sortable: false,
    title: 'Tag',
    type: 'Tag',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId11',
    sortable: false,
    title: 'Account',
    type: 'Account',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId12',
    sortable: false,
    title: 'User',
    type: 'User',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId14',
    sortable: false,
    title: 'TextEmpty',
    type: 'Text',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
];

const columns2: Column[] = [
  {
    id: 'someId5',
    sortable: false,
    title: 'Percent',
    type: 'Percent',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
  {
    id: 'someId6',
    sortable: false,
    title: 'Digit',
    type: 'Digit',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
];

const columns3: Column[] = [
  {
    id: 'someId2',
    sortable: false,
    title: 'Link',
    type: 'Link',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
];

const columns4: Column[] = [
  {
    id: 'someId4',
    sortable: false,
    title: 'Diff',
    type: 'Diff',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
];

const rows: Row[] = Array(10)
  .fill(true)
  .map((item, index) => {
    const fields = columns.map((column) => ({
      id: column.id,
      type: column.type,
      data: generateCellByType(column.type),
    }));
    fields[fields.length - 1] = {
      id: 'someId14',
      type: 'Empty',
      data: undefined,
    };
    return {
      id: String(index),
      fields,
    };
  });

export const TableData: Table = {
  meta: {
    fieldsVisibility: columns.map((column) => column.id),
    fields: columns,
  },
  data: rows,
};

const rows2: Row[] = Array(100)
  .fill(true)
  .map((item, index) => ({
    id: String(index),
    fields: columns2.map((column) => ({
      id: column.id,
      type: column.type,
      data: generateCellByType(column.type),
    })),
  }));

export const TableTwoColumn: Table = {
  meta: {
    fieldsVisibility: columns2.map((column) => column.id),
    fields: columns2,
  },
  data: rows2,
};

const rows3: Row[] = Array(100)
  .fill(true)
  .map((item, index) => ({
    id: String(index),
    fields: columns3.map((column) => ({
      id: column.id,
      type: column.type,
      data: generateCellByType(column.type),
    })),
  }));

export const TableOneColumn: Table = {
  meta: {
    fieldsVisibility: columns3.map((column) => column.id),
    fields: columns3,
  },
  data: rows3,
};

export const TableWithLinks: Table = {
  meta: {
    fieldsVisibility: columns3.map((column) => column.id),
    fields: columns3,
  },
  data: rows3,
};

const rows4: Row[] = Array(100)
  .fill(true)
  .map((item, index) => ({
    id: String(index),
    fields: columns4.map((column) => ({
      id: column.id,
      type: column.type,
      data: generateCellByType(column.type),
    })),
  }));

export const TableWithDiff: Table = {
  meta: {
    fieldsVisibility: columns4.map((column) => column.id),
    fields: columns4,
  },
  data: rows4,
};

const columns5: Column[] = [
  ...columns,
  {
    id: 'someId10',
    sortable: false,
    title: 'Buttons',
    type: 'List',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
  },
];

const rows5: Row[] = Array(10)
  .fill(true)
  .map((item, index) => {
    return {
      id: String(index),
      fields: columns5.map((column) => {
        return {
          id: column.id,
          type: column.type,
          data:
            column.type === 'List'
              ? generateButtonCell(column.id)
              : generateCellByType(column.type),
        };
      }),
    };
  });

export const TableWithEdit: Table = {
  meta: {
    createAction: {
      access: 3,
      defaultFields: rows5[0].fields,
    },
    fieldsVisibility: columns5.map((column) => column.id),
    fields: columns5,
  },
  data: rows5,
};

const TagsListCellsColumns = [
  {
    id: 'someId1',
    sortable: false,
    title: 'TagsList',
    type: 'List',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
    columnWidth: '300px',
  },
];
// @ts-ignore
const rowsWithTagsListCells: Row[] = Array(100)
  .fill(true)
  .map((item, index) => ({
    id: String(index),
    fields: TagsListCellsColumns.map((column) => ({
      id: column.id,
      type: column.type,
      data: [
        {
          data: { id: 1, name: 'Test', color: 'ba99ff' },
          id: 'Tags',
          type: 'Tag',
        },
        {
          data: { id: 2, name: 'Закрывашки', color: 'A8DCFF' },
          id: 'Tags',
          type: 'Tag',
        },
        {
          data: { id: 3, name: 'Невыясненные', color: 'FFE4A4' },
          id: 'Tags',
          type: 'Tag',
        },
        {
          data: { id: 4, name: 'Некорректные', color: 'FFB6AB', link: '/' },
          id: 'Tags',
          type: 'Tag',
        },
      ],
    })),
  }));

export const TableWithTagsListCells: Table = {
  meta: {
    fieldsVisibility: TagsListCellsColumns.map((column) => column.id),
    fields: TagsListCellsColumns,
  },
  data: rowsWithTagsListCells,
};

const CustomViewCellsColumns = [
  {
    id: 'someId1',
    sortable: false,
    title: 'TicketShortInfo',
    type: 'CustomView',
    isPinned: false,
    access: 3,
    isFieldsUpdateNeeded: false,
    options: {
      module: 'Cases',
    },
  },
];

const rowsWithCustomCells: Row[] = Array(100)
  .fill(true)
  .map((item, index) => ({
    id: String(index),
    fields: CustomViewCellsColumns.map((column) => ({
      id: column.id,
      type: column.type,
      data: generateCellByType(column.type),
    })),
  }));

export const TableWithCustomViewCells: Table = {
  meta: {
    fieldsVisibility: CustomViewCellsColumns.map((column) => column.id),
    fields: CustomViewCellsColumns,
  },
  data: rowsWithCustomCells,
};
