import React from 'react';
import Table from '../Table';
import { TableEditable } from '../TableEditable';
import { ThemeProvider } from '../themes';

import {
  TableData,
  TableTwoColumn,
  TableOneColumn,
  TableWithLinks,
  TableWithDiff,
  TableWithEdit,
  TableWithTagsListCells,
  TableWithCustomViewCells,
} from './Table.examples.config';

export default {
  title: 'Table',
  component: Table,
  argTypes: {
    theme: {
      options: ['default', 'clean', 'mg', 'neo'],
      defaultValue: 'default',
      control: 'select',
    },
    selectedRows: { control: null },
    rowsInLoading: { control: null },
  },
  decorators: [
    (Story, { args }) => {
      return (
        <ThemeProvider value={args.theme}>
          <Story />
        </ThemeProvider>
      );
    },
  ],
};

export const table = (args) => <Table {...args} />;
table.args = {
  tableData: TableData,
};

export const withSelect = (args) => <TableEditable {...args} />;
withSelect.args = {
  selectedRows: new Set(['1', '5']),
  tableData: TableData,
};

export const pinnedWithSelect = (args) => <TableEditable {...args} />;
pinnedWithSelect.args = {
  selectedRows: new Set(['1', '5']),
  tableData: TableData,
  theme: 'neo',
  bunkerSettings: {
    pinCheckbox: true,
    fieldsSettings: [
      {
        fieldId: 'someId1',
        isPinned: true,
      },
      {
        fieldId: 'someId2',
        minColumnWidth: '300px',
      },
      {
        fieldId: 'someId3',
        minColumnWidth: '300px',
      },
      {
        fieldId: 'someId4',
        minColumnWidth: '300px',
      },
    ],
  },
};

export const editable = (args) => <TableEditable {...args} />;
editable.args = {
  baseUrl: '/v0/blocks/accountCredits/table',
  tableData: TableWithEdit,
};

export const oneColumn = (args) => <Table {...args} />;
oneColumn.args = {
  tableData: TableOneColumn,
};

export const twoColumns = (args) => <Table {...args} />;
twoColumns.args = {
  tableData: TableTwoColumn,
};

export const withLinks = (args) => <Table {...args} />;
withLinks.args = {
  tableData: TableWithLinks,
};

export const withDiff = (args) => <Table {...args} />;
withDiff.args = {
  tableData: TableWithDiff,
};

export const withTagsListCells = (args) => <Table {...args} />;
withTagsListCells.args = {
  tableData: TableWithTagsListCells,
};

export const withCustomViewCells = (args) => <Table {...args} />;
withCustomViewCells.args = {
  tableData: TableWithCustomViewCells,
};
