import { Form, DataSet } from 'types/api/form/Form';
import { UserField } from 'types/api/form/Fields/User';
import { AccountField } from 'types/api/form/Fields/Account';
import { MoneyField } from 'types/api/form/Fields/Money';
import { CheckboxField } from 'types/api/form/Fields/Checkbox';
import { CustomViewField } from 'types/api/form/Fields/CustomView';
import { SelectField } from 'types/api/form/Fields/Select';
import { SuggestField } from 'types/api/form/Fields/Suggest';
import { TextField, Text } from 'types/api/form/Fields/Text';
import { LinkField } from 'types/api/form/Fields/Link';
import { TagField } from 'types/api/form/Fields/Tag';
import { ButtonField } from 'types/api/form/Fields/Button';
import { RowActionField } from 'types/api/form/Fields/RowAction';
import { PercentField } from 'types/api/form/Fields/Percent';
import { DigitField } from 'types/api/form/Fields/Digit';
import { DiffField } from 'types/api/form/Fields/Diff';
import { ListField } from 'types/api/form/Fields/List';
import { EmptyField } from 'types/api/form/Fields/Empty';
import { TextareaField } from 'types/api/form/Fields/Textarea';
import { FieldMetaAny, FieldDataAny } from 'types/api/form/Form';
import { DateTimeField } from 'types/api/form/Fields/DateTime';
import { ThemeTypes } from './themes';
import { FlagDependantConfig } from '../../utils/hooks/useBunker/useBunker.types';

export { Text };

export type SimpleCellType =
  | 'Account'
  | 'User'
  | 'RowAction'
  | 'Button'
  | 'Checkbox'
  | 'CustomView'
  | 'Text'
  | 'Textarea'
  | 'Digit'
  | 'Diff'
  | 'Money'
  | 'Percent'
  | 'Link'
  | 'Tag'
  | 'Empty'
  | 'Unknown'
  | 'Select'
  | 'Suggest'
  | 'DateTime';

export type ComplexCellType = 'List';

export type CellType = SimpleCellType | ComplexCellType;

export type CellTypeWithoutInnerPresentation = 'List' | 'Empty' | 'Unknown';

// Field aliases for Cells

export type CustomViewCell<ViewData> = Required<CustomViewField<ViewData>['data']>;

export type ButtonCell = Required<ButtonField['data']>;

export type AccountCell = Required<AccountField['data']>;

export type UserCell = Required<UserField['data']>;

export type RowActionCell = Required<RowActionField['data']>;

export type SelectCell = Required<SelectField['data']>;

export type CheckboxCell = Required<CheckboxField['data']>;

export type SuggestCell = Required<SuggestField['data']>;

export type TextCell = Required<TextField['data']>;

export type TextareaCell = Required<TextareaField['data']>;

export type DigitCell = Required<DigitField['data']>;

export type MoneyCell = Required<MoneyField['data']>;

export type PercentCell = Required<PercentField['data']>;

export type LinkCell = Required<LinkField['data']>;

export type TagCell = Required<TagField['data']>;

export type DiffCell = Required<DiffField['data']>;

export type EmptyCell = EmptyField['data'];

export type ListCell = Required<ListField['data']>;

export type DateTimeCell = Required<DateTimeField['data']>;

export type Cell = FieldDataAny;

export type Column = FieldMetaAny;

export type Row = DataSet;

export type Table = Form;

export interface BunkerFieldSettings {
  fieldId: string;
  isPinned?: boolean;
  maxColumnWidth?: string;
  minColumnWidth?: string;
}

export interface BunkerTableSettings extends FlagDependantConfig {
  theme?: ThemeTypes;
  pinCheckbox?: boolean;
  fieldsSettings?: BunkerFieldSettings[];
}

export interface TableProps {
  className?: string;
  tableData: Table;
  rowsInLoading?: string[];
  bunkerSettings?: BunkerTableSettings;
  withControls?: boolean;
  selectedRows?: Set<string>;
  fetchingData?: boolean;
}
