import { Table } from '../../Table.types';

export const tableData: Table = {
  meta: {
    createAction: {
      access: 3,
      defaultFields: [
        {
          id: 'someId1',
          type: 'Text',
          data: { value: 'default Text' },
        },
        {
          id: 'someId2',
          type: 'Textarea',
          data: { value: 'default Textarea' },
        },
      ],
    },
    fieldsVisibility: ['someId1', 'someId2', 'someId3'],
    fields: [
      {
        id: 'someId1',
        sortable: false,
        title: 'SomeText',
        type: 'Text',
        isPinned: false,
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'someId2',
        sortable: false,
        title: 'Description',
        type: 'Textarea',
        isPinned: false,
        access: 3,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'someId3',
        sortable: false,
        title: '',
        type: 'List',
        isPinned: false,
        access: 3,
        isFieldsUpdateNeeded: false,
      },
    ],
  },
  data: [
    {
      id: 'id1',
      fields: [
        {
          id: 'someId1',
          type: 'Text',
          data: { value: 'Text Value 1' },
        },
        {
          id: 'someId2',
          type: 'Textarea',
          data: { value: 'Textarea Value 1' },
        },
        {
          id: 'someId3',
          type: 'List',
          data: [
            { id: 'someId3', type: 'Button', data: { type: 'EditButton', access: 3 } },
            { id: 'someId3', type: 'Button', data: { type: 'RemoveButton', access: 3 } },
          ],
        },
      ],
    },
  ],
};
