import React, { FC, useContext } from 'react';
import cx from 'classnames';
import { HeaderCellProps } from './HeaderCell.types';
import themes from './themes';
import { themeContext } from '../../themes';

export const HeaderCell: FC<HeaderCellProps> = ({ column, className }) => {
  const theme = useContext(themeContext);
  const css = themes[theme] || themes.default;
  const cellCn = cx(css.HeaderCell, className, {
    [css.HeaderCell_sticky]: column.isPinned,
  });

  return <div className={cellCn}>{column.title}</div>;
};
