import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { ControlIconProps } from './ControlIcon.types';
import css from './ControlIcon.module.css';

export const ControlIcon: FC<ControlIconProps> = ({ sort, isFiltered = false }) => {
  if (isFiltered) {
    return <Icon className={css.ControlIcon} svg="filter" svgSize="ms" />;
  }
  if (sort) {
    const svgName = sort.order === 'Asc' ? 'sortAsc' : 'sortDesc';
    return <Icon className={css.ControlIcon} svg={svgName} svgSize="ms" />;
  }

  return <Icon className={css.ControlIcon} svg="arrowShort" svgSize="ms" />;
};
