import React, { FC } from 'react';
import cx from 'classnames';
import Select from '@crm/components/dist/lego2/Select';
import { SearchTypeProps } from './SearchType.types';
import { SEARCH_TYPES } from './SearchType.constants';
import css from './SearchType.module.css';

export const SearchType: FC<SearchTypeProps> = (props) => {
  const { value, onChange, className } = props;

  return (
    <Select
      className={cx(css.SearchType, className)}
      options={SEARCH_TYPES}
      value={value}
      onChange={onChange}
      hasEmptyValue={false}
    />
  );
};
