import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './SortPanel.module.css';
import { SortPanelProps, SortOrder } from './SortPanel.types';

export const SortPanel: FC<SortPanelProps> = ({ column, changeSort, sort }) => {
  const handleChangeSort = (order: SortOrder) => () => {
    if (sort?.order && sort?.order === order) {
      changeSort(undefined);
      return;
    }
    changeSort({ id: column.id, order });
  };

  return (
    <div className={css.SortPanel}>
      <Text typography="body-long-m" color="secondary">
        Сортировать
      </Text>
      <div className={css.SortPanel__sectionContent}>
        <span className={css.SortPanel__sortItem} onClick={handleChangeSort('Desc')}>
          <Icon className={css.SortPanel__icon} svg="sortDesc" svgSize="ml" />
          <Text
            typography="body-long-m"
            color="primary"
            weight={sort?.order === 'Desc' ? 'medium' : 'regular'}
          >
            По убыванию (Я – А)
          </Text>
        </span>
        <span className={css.SortPanel__sortItem} onClick={handleChangeSort('Asc')}>
          <Icon className={css.SortPanel__icon} svg="sortAsc" svgSize="ml" />
          <Text
            typography="body-long-m"
            color="primary"
            weight={sort?.order === 'Asc' ? 'medium' : 'regular'}
          >
            По возрастанию (А – Я)
          </Text>
        </span>
      </div>
    </div>
  );
};
