import React, { FC } from 'react';
import TextInput from '@crm/components/dist/lego2/Textinput';
import { ContainsStringProps } from './ContainsString.types';

export const ContainsString: FC<ContainsStringProps> = ({ changeFilter, filter }) => {
  const handleChangeFilter = (value: String) => {
    if (filter) {
      const data = value && { value: String(value) };
      changeFilter({ type: filter.type, data });
    }
  };

  return (
    <div>
      <TextInput
        data-testid="ContainsString_Filter"
        placeholder="Поиск..."
        hasClear
        onChange={handleChangeFilter}
        value={filter?.data?.value ? String(filter.data.value) : ''}
      />
    </div>
  );
};
