import React, { FC } from 'react';
import TextInput from '@crm/components/dist/lego2/Textinput';
import { MatchNumberProps } from './MatchNumber.types';

export const MatchNumber: FC<MatchNumberProps> = ({ changeFilter, filter }) => {
  const handleChangeFilter = (value: String) => {
    if (filter) {
      const data = value && { value: Number(value) };
      changeFilter({ type: filter.type, data });
    }
  };

  return (
    <div>
      <TextInput
        data-testid="MatchNumber_Filter"
        placeholder="Поиск..."
        type="number"
        hasClear={false}
        onChange={handleChangeFilter}
        value={filter?.data?.value ? String(filter.data.value) : ''}
      />
    </div>
  );
};
