import React, { FC } from 'react';
import TextInput from '@crm/components/dist/lego2/Textinput';
import { RangeNumberProps, RangeNumberFilter } from './RangeNumber.types';
import css from './RangeNumber.module.css';

export const RangeNumber: FC<RangeNumberProps> = ({ changeFilter, filter }) => {
  const from = filter?.data?.from;
  const to = filter?.data?.to;
  const newFilterValue = { type: filter?.type } as RangeNumberFilter;

  const handleChangeFrom = (value: String) => {
    if (filter) {
      let data;
      if (to) {
        data = { to };
      }
      if (value) {
        data = { ...data, from: Number(value) };
      }
      if (data) {
        newFilterValue.data = data;
      }
      changeFilter(newFilterValue);
      return;
    }
  };

  const handleChangeTo = (value: String) => {
    if (filter) {
      let data;
      if (from) {
        data = { from };
      }
      if (value) {
        data = { ...data, to: Number(value) };
      }
      if (data) {
        newFilterValue.data = data;
      }
      changeFilter(newFilterValue);
      return;
    }
  };

  return (
    <div className={css.RangeNumber}>
      <div className={css.RangeNumber__field}>
        <TextInput
          data-testid="RangeNumber_Filter_From"
          placeholder="От"
          type="number"
          hasClear={false}
          onChange={handleChangeFrom}
          value={filter?.data?.from ? String(filter.data.from) : ''}
        />
      </div>
      <div className={css.RangeNumber__field}>
        <TextInput
          data-testid="RangeNumber_Filter_To"
          placeholder="До"
          type="number"
          hasClear={false}
          onChange={handleChangeTo}
          value={filter?.data?.to ? String(filter.data.to) : ''}
        />
      </div>
    </div>
  );
};
