import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { SelectedItemProps } from './SelectedItem.types';
import css from './SelectedItem.module.css';
export const SelectedItem: FC<SelectedItemProps> = ({ item, removeItem }) => {
  const handleRemove = () => {
    removeItem(item);
  };

  return (
    <div className={css.SelectedItem} key={item.id}>
      <span className={css.SelectedItem__caption}>{item.name}</span>
      <span className={css.SelectedItem__close} onClick={handleRemove}>
        <Icon className={css.SelectedItem__closeIcon} svg="close" />
      </span>
    </div>
  );
};
