import React, { FC } from 'react';
import { SelectedItemListProps, SuggestMultipleFilter } from './SelectedItemList.types';
import { SelectedItem } from './SelectedItem';

export const SelectedItemList: FC<SelectedItemListProps> = ({ changeFilter, filter }) => {
  const handleRemoveItem = (value) => {
    const newFilter: SuggestMultipleFilter = { type: filter.type, provider: filter.provider };
    const newFilterValue = filter?.data?.value.filter((item) => item.id !== value.id);
    if (newFilterValue && newFilterValue.length > 0) {
      newFilter.data = { value: newFilterValue };
    }
    changeFilter(newFilter);
  };

  return (
    <div>
      {filter.data?.value.map((item) => (
        <SelectedItem key={item.id} item={item} removeItem={handleRemoveItem} />
      ))}
    </div>
  );
};
