import React, { FC, useState, useRef } from 'react';
import { Suggest } from 'components/design/Attribute/ReadEdit/Suggest';
import { Option } from 'components/design/Attribute/Edit/PopupItems/Option';
import { SuggestMultipleProps, ItemType, SuggestResponse } from './SuggestMultiple.types';
import { mapper } from './utils/mapper';
import { SelectedItemList } from './SelectedItemList';
import css from './SuggestMultiple.module.css';

const getItemId = (item: { id: string }) => item.id;

const OptionWithId = ({ item, ...restProps }) => {
  const newItem = { name: item.name, value: item.id };
  return <Option {...restProps} item={newItem} isSelected={item.isSelected} iconSize="m" />;
};

export const SuggestMultiple: FC<SuggestMultipleProps> = ({ changeFilter, filter }) => {
  const [isEditing, setEditing] = useState(false);
  const [text, setText] = useState('');
  const parentRef = useRef<HTMLDivElement>(null);
  const itemsRef = useRef<ItemType[]>([]);

  const editingStart = () => {
    setEditing(true);
  };

  const editingStop = () => {
    setEditing(false);
  };

  const shareItems = (items) => {
    itemsRef.current = items;
  };

  const handleChangeFilter = (value) => {
    const item = itemsRef.current.find((item) => item.id === value);
    if (filter && item) {
      let data = filter.data;
      if (data && data.value.find((item) => item.id === value)) {
        return;
      }
      data = data ? { value: [...data.value, item] } : { value: [item] };

      changeFilter({ type: filter.type, provider: filter.provider, data });
      setText('');
    }
  };

  return (
    <div className={css.SuggestMultiple} ref={parentRef}>
      <Suggest
        url={filter?.provider || ''}
        mapper={(data) => mapper(data as SuggestResponse, filter?.data)}
        label="Поиск..."
        access={3}
        text={text}
        onTextChange={setText}
        placeholder="Поиск"
        renderItem={OptionWithId}
        onChange={handleChangeFilter}
        isEditing={isEditing}
        onEditingStart={editingStart}
        onEditingStop={editingStop}
        shareItems={shareItems}
        parentRef={parentRef}
        getValue={getItemId}
      />
      {filter?.data && <SelectedItemList changeFilter={changeFilter} filter={filter} />}
    </div>
  );
};
