import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { Text } from '@crm/components/dist/lego2/Text';
import { Account } from 'types/api/form/Fields/Account';
import { SuggestFilterAdapter, SuggestFilterAdapterProps } from '../SuggestFilterAdapter';
import css from './SuggestAccounts.module.css';

const renderItem = (account: Account, { isSelected }) => {
  return (
    <div className={css.SuggestAccounts__item}>
      <div className={css.SuggestAccounts__main}>
        <Text className={css.SuggestAccounts__name}>{account.name}</Text>
        <Text color="secondary">{account.id}</Text>
      </div>
      {isSelected && <Icon className={css.SuggestAccounts__check} svg="check2" svgSize="m" />}
    </div>
  );
};

export const SuggestAccounts: FC<SuggestFilterAdapterProps<Account>> = (props) => {
  return (
    <div data-testid="SuggestAccounts">
      <SuggestFilterAdapter {...props} renderPopupItem={renderItem} />
    </div>
  );
};
