import React from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { GeneralSuggestItem } from 'types/api/form/UserFilter';
import { SuggestWithTags } from 'components/SuggestWithTags';
import { GeneralSuggestFilter, SuggestFilterAdapterProps } from './SuggestFilterAdapter.types';
import css from './SuggestFilterAdapter.module.css';

export const SuggestFilterAdapter = <T extends GeneralSuggestItem>({
  changeFilter,
  filter,
  renderPopupItem,
  renderSelectedItem,
}: SuggestFilterAdapterProps<T>) => {
  const handleChangeFilter = (value) => {
    if (filter) {
      const newFilter: GeneralSuggestFilter<T> = { type: filter.type, provider: filter.provider };
      if (value.length) {
        newFilter.data = { value };
      }
      changeFilter(newFilter);
    }
  };

  return (
    <SuggestWithTags
      provider={filter?.provider!}
      onChange={handleChangeFilter}
      value={filter?.data?.value || []}
      renderItem={renderPopupItem}
      renderBubble={renderSelectedItem}
      placeholder="Поиск"
      iconRight={<Icon className={css.Suggest__search} svg="loupe" svgSize="ml" />}
      clearSearchOnSelect
    />
  );
};
