import React, { FC } from 'react';
import { Option as OptionComponent } from 'components/design/Attribute/Edit/PopupItems/Option';
import { Option } from 'types/api/form/Fields/Option';
import { Bubble, BubbleProps } from 'components/Bubble';
import { Text } from '@crm/components/dist/lego2/Text';
import { SuggestFilterAdapter, SuggestFilterAdapterProps } from '../SuggestFilterAdapter';

const renderOption = (option, { isSelected }) => {
  const newItem = { name: option.name, value: option.id };
  return <OptionComponent item={newItem} isSelected={isSelected} iconSize="m" />;
};

const renderSelectedBubble = (item: Option, props: BubbleProps) => (
  <Bubble canDelete {...props}>
    <Text typography="control-m">{((item as unknown) as Option).name}</Text>
  </Bubble>
);

export const SuggestMultiple: FC<SuggestFilterAdapterProps<Option>> = (props) => {
  return (
    <SuggestFilterAdapter
      {...props}
      renderPopupItem={renderOption}
      renderSelectedItem={renderSelectedBubble}
    />
  );
};
