import React, { FC } from 'react';
import { User } from 'types/entities/user';
import { PopupItemUser } from 'components/PopupItemUser';
import { RenderSelectedBubbleProps, SelectedBubbleUser } from 'components/SelectedBubbleUser';
import { SuggestFilterAdapter, SuggestFilterAdapterProps } from '../SuggestFilterAdapter';

const renderUser = (user: User, { isSelected }) => {
  return (
    <PopupItemUser
      user={{ id: user.id, name: user.name, login: user.login }}
      isSelected={isSelected}
    />
  );
};

const renderSelectedBubble = (user: User, props: RenderSelectedBubbleProps) => {
  return <SelectedBubbleUser user={user} canDelete {...props} />;
};

export const SuggestUsers: FC<SuggestFilterAdapterProps<User>> = (props) => {
  return (
    <div data-testid="SuggestUsers">
      <SuggestFilterAdapter
        {...props}
        renderPopupItem={renderUser}
        renderSelectedItem={renderSelectedBubble}
      />
    </div>
  );
};
