import React, { FC, useState, useCallback } from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import debounce from 'lodash/debounce';
import { SearchInputProps } from './SearchInput.types';

export const SearchInput: FC<SearchInputProps> = ({ setSearchQuery }) => {
  const [searchText, setSearchText] = useState('');

  const updateSearchQuery = useCallback(
    debounce((query: string) => {
      setSearchQuery(query);
    }, 500),
    [],
  );

  const handleChangeSearchText = (text: string) => {
    setSearchText(text);
    updateSearchQuery(text);
  };

  return (
    <Textinput
      data-testid="TreeSuggestMultiple_searchInput"
      placeholder="Поиск"
      value={searchText}
      onChange={handleChangeSearchText}
      hasClear={false}
      autoFocus
    />
  );
};
