import React, { FC } from 'react';
import OriginalTag from 'lego/components/Tag';
import cx from 'classnames';
import { SelectedNodeProps } from './SelectedNode.types';
import css from './SelectedNode.module.css';

export const SelectedNode: FC<SelectedNodeProps> = ({ className, ...otherProps }) => {
  const partClassNames = {
    button: css.SelectedNode__button,
    label: css.SelectedNode__label,
  };
  return (
    <OriginalTag
      {...otherProps}
      partClassNames={partClassNames}
      className={cx(className, css.SelectedNode)}
    >
      {otherProps.item.fullName}
    </OriginalTag>
  );
};
