import React, { FC } from 'react';
import Tags from 'lego/components/Tags';
import { SelectedNodeListProps } from './SelectedNodeList.types';
import css from './SelectedNodeList.module.css';
import { SelectedNode } from './SelectedNode';

const getKey = (item) => item.fullName;

export const SelectedNodeList: FC<SelectedNodeListProps> = ({ filter, onRemove }) => {
  const items = filter.data?.value;
  const handleRemove = (key, item) => {
    onRemove(item);
  };
  return (
    <Tags
      className={css.SelectedNodeList}
      component={SelectedNode}
      items={items}
      getKey={getKey}
      onDelete={handleRemove}
    />
  );
};
