import React, { FC, useRef } from 'react';
import AutoSizer from 'react-virtualized-auto-sizer';
import { VariableSizeTree } from 'react-vtree';
import { TreeProps } from './Tree.types';
import css from './Tree.module.css';
import { TreeNode } from './TreeNode';
import { createTreeWalker } from './utils/treeWalker';
import { growTree } from './utils/growTree';

export const Tree: FC<TreeProps> = ({ tree, onNodeClick, isForceOpen, selectedIds }) => {
  const boxRef = useRef<HTMLDivElement>(null);
  const nodesHeightCache = useRef({});
  const treeWalker = createTreeWalker(growTree(tree), {
    onNodeClick,
    boxRef,
    isForceOpen,
    selectedIds,
    nodesHeightCache: nodesHeightCache.current,
  });
  return (
    <div className={css.Tree}>
      <div className={css.Tree__detectSizeBox} ref={boxRef} />
      <AutoSizer>
        {({ height, width }) => (
          <VariableSizeTree treeWalker={treeWalker} width={width} height={height}>
            {TreeNode}
          </VariableSizeTree>
        )}
      </AutoSizer>
    </div>
  );
};
