import React, { FC } from 'react';
import cx from 'classnames';
import { Chevron } from 'components/design/ListItem/Chevron';
import { Check } from 'components/design/ListItem/Check';
import Select from 'components/Select';
import { TreeNodeProps } from './TreeNode.types';
import css from './TreeNode.module.css';
import { NESTING_LEVEL_PADDING } from './TreeNode.constants';

export const TreeNode: FC<TreeNodeProps> = (props) => {
  const {
    data: { node, nestingLevel, isLeaf, onNodeClick, select, selected, isForceOpen },
    style: treeNodeStyle,
    isOpen,
    toggle,
  } = props;
  const style = {
    ...treeNodeStyle,
    paddingLeft: `${nestingLevel * NESTING_LEVEL_PADDING}px`,
  };

  const handleSelectNode = () => {
    onNodeClick(node);
  };

  const handleExpandNode = () => {
    if (!isLeaf && !isForceOpen) {
      toggle();
    }
  };

  const className = cx(css.TreeNode, {
    [css.TreeNode_isLeaf]: isLeaf,
  });

  return (
    <div className={className} style={style}>
      {!isLeaf && (
        <div data-testid={`TreeNode_expandArrow_${node.id}`} onClick={handleExpandNode}>
          <Chevron direction={isOpen ? 'bottom' : 'right'} />
        </div>
      )}
      <div onClick={handleSelectNode} className={css.TreeNode__item}>
        <Select value={node.name} range={select} />
        {selected && <Check className={css.TreeNode__check} size="m" />}
      </div>
    </div>
  );
};
