import React, { RefObject } from 'react';
import { renderToString } from 'react-dom/server';
import { TreeNode } from '../TreeNode';
import { TreeNodeData } from './treeWalker';

export const getElementHeight = (
  container: RefObject<HTMLDivElement>,
  cache: Record<string, number>,
  props: { data: Omit<TreeNodeData, 'defaultHeight'> },
): number => {
  const nodeId = props.data.node.id;
  if (cache[nodeId]) {
    return cache[nodeId];
  }
  if (container.current === null) {
    return 0;
  }
  // В ноду не завозим пропсы коллБэков - нам нужно просто посчитать размер
  // @ts-ignore
  const rendered = renderToString(<TreeNode {...props} style={{}} />);
  container.current.innerHTML = rendered;
  const renderedNode = container.current.firstChild as HTMLDivElement;
  const height = renderedNode?.offsetHeight;
  cache[nodeId] = height;
  return height;
};
