import memoize from 'memoize-one';
import { getElementHeight } from '../getElementHeight';
import {
  TreeRoot,
  CreateTreeWalkerOptions,
  TreeWalkerNode,
  TreeNodeData,
} from './treeWalker.types';

const createTreeWalker = (
  treeRoot: TreeRoot,
  {
    onNodeClick,
    boxRef,
    isForceOpen = false,
    selectedIds,
    nodesHeightCache,
  }: CreateTreeWalkerOptions,
) => {
  return function* treeWalker(refresh: boolean) {
    const stack = [...treeRoot.items]
      .map<TreeWalkerNode>((node) => ({ nestingLevel: 0, node }))
      .reverse();

    while (stack.length !== 0) {
      const node = stack.pop();
      if (!node) {
        continue;
      }

      const {
        node: { id: numberId, name, fullName, ids = [], items = [], select },
        nestingLevel,
      } = node;
      const isLeaf = items.length === 0;
      const id = numberId.toString();
      const data: Omit<TreeNodeData, 'defaultHeight'> = {
        isOpenByDefault: isForceOpen,
        id,
        nestingLevel,
        onNodeClick,
        isLeaf,
        select,
        isForceOpen,
        selected: selectedIds.has(id),
        node: {
          name,
          fullName,
          ids,
          id,
          items,
        },
      };

      const isOpened = yield refresh
        ? {
            defaultHeight: getElementHeight(boxRef, nodesHeightCache, { data }),
            ...data,
          }
        : id;

      if (items.length !== 0 && (isOpened || isForceOpen)) {
        for (let i = items.length - 1; i >= 0; i--) {
          stack.push({
            nestingLevel: nestingLevel + 1,
            node: items[i],
          });
        }
      }
    }
  };
};

const memoized = memoize(createTreeWalker);

export { memoized as createTreeWalker };
