import { RefObject } from 'react';
import { TreeNode } from '../../Tree.types';
export interface TreeRoot {
  id: 0;
  items: TreeNode[];
}

export interface TreeWalkerNode {
  node: TreeNode & { select?: number[] };
  nestingLevel: number;
}

export interface TreeNodeData {
  isOpenByDefault: boolean;
  id: string;
  nestingLevel: number;
  onNodeClick: (node: TreeNode) => void;
  isLeaf: boolean;
  select?: number[];
  isForceOpen: boolean;
  selected: boolean;
  node: TreeNode;
  defaultHeight: number;
}

export interface CreateTreeWalkerOptions {
  onNodeClick: (node: TreeNode) => void;
  boxRef: RefObject<HTMLDivElement>;
  isForceOpen?: boolean;
  selectedIds: Set<string>;
  nodesHeightCache: Record<string, number>;
}
