import { get } from 'api/common';
import { TreeSuggestMultipleResponse, TreeNode } from '../TreeSuggestMultiple.types';

type CbSuccess = (items: TreeNode[]) => void;
type SetLoading = (isLoading: boolean) => void;

export const fetchTreeDict = (url: string, cbSuccess: CbSuccess, setLoading: SetLoading) => {
  setLoading(true);
  const request = get<TreeSuggestMultipleResponse>({ url })
    .then((response) => {
      cbSuccess(response.items);
    })
    .finally(() => {
      if (!request.isCancelled()) {
        setLoading(false);
      }
    });
  return request;
};
