import React, { FC, useMemo } from 'react';
import { Bubble } from 'components/Bubble';
import { SelectedBlockProps } from './SelectedBlock.types';
import css from './SelectedBlock.module.css';

export const SelectedBlock: FC<SelectedBlockProps> = (props) => {
  const { selected, onSelectToggle, treeDictionary } = props;

  const items = useMemo(() => selected.map((id) => treeDictionary[id!]).toArray(), [
    selected,
    treeDictionary,
  ]);

  return (
    <div className={css.SelectedBlock} data-testid="tree-view-selected-block">
      {items.map((item) => (
        <Bubble
          key={item.id}
          className={css.SelectedItem}
          canDelete
          onDelete={() => onSelectToggle(item.id)}
        >
          {item.data.fullName}
        </Bubble>
      ))}
    </div>
  );
};
