import React, { FC, useState, useEffect, useMemo } from 'react';
import { TreeView } from 'components/TreeView';
import { Overlay } from 'components/Overlay';
import { buildTreeDictionary } from 'components/TreeView/Tree/Tree.utils';
import { fetchTreeDict } from '../TreeSuggestMultiple/utils/fetchTreeDict';
import { treeViewAdapter } from './TreeSuggestMultiple.utils';
import { SelectedBlock } from './SelectedBlock';
import {
  TreeSuggestMultipleProps,
  TreeSuggestMultipleFilter,
  TreeNode,
} from '../TreeSuggestMultiple/TreeSuggestMultiple.types';
import css from './TreeSuggestMultiple.module.css';

export const TreeSuggestMultiple: FC<TreeSuggestMultipleProps> = ({ changeFilter, filter }) => {
  const [tree, setTree] = useState<TreeNode[] | undefined>();
  const [isLoading, setLoading] = useState(false);

  useEffect(() => {
    const request = fetchTreeDict(filter?.provider || '', setTree, setLoading);
    return () => {
      request.cancel();
    };
  }, []);

  const selectedIds = useMemo(
    () => Array.from(new Set(filter?.data?.value?.map((item) => item.id)) || []),
    [filter],
  );

  const items = useMemo(() => tree && treeViewAdapter(tree), [tree]);
  const treeDictionary = useMemo(() => items && buildTreeDictionary(items), [items]);

  const handleChange = (ids) => {
    const newFilter: TreeSuggestMultipleFilter = { type: filter.type, provider: filter.provider };
    const newFilterValue = ids.map((id) => ({ id, ids: treeDictionary[id].data.ids }));

    if (newFilterValue && newFilterValue.length > 0) {
      newFilter.data = { value: newFilterValue };
    }

    changeFilter(newFilter);
  };

  return (
    <div className={css.TreeSuggestMultiple}>
      <Overlay display={isLoading} hasSpinner />
      {tree && (
        <div className={css.TreeSuggestMultiple__wrap}>
          <TreeView
            showSearch
            showSelectedBlock
            onChange={handleChange}
            SelectedBlock={SelectedBlock}
            selected={selectedIds}
            items={items}
          />
        </div>
      )}
    </div>
  );
};
