import { config } from 'services/Config';
import { MatchNumber } from './MatchNumber';
import { RangeNumber } from './RangeNumber';
import { ContainsString } from './ContainsString';
import { SuggestMultiple as SuggestMultipleV2 } from './SuggestV2/SuggestMultipleV2';
import { TreeSuggestMultiple } from './TreeSuggestMultiple';
import { TreeSuggestMultiple as TreeSuggestMultipleV2 } from './TreeSuggestMultipleV2';
import { SuggestUsers } from './SuggestV2/SuggestUsers';
import { SuggestAccounts } from './SuggestV2/SuggestAccounts';
import { SuggestMultiple } from './SuggestMultiple';

export const getFilterComponents = () => ({
  MatchNumber,
  RangeNumber,
  ContainsString,
  SuggestMultiple: config.value.features.newDesignLift ? SuggestMultipleV2 : SuggestMultiple,
  TreeSuggestMultiple: config.value.features.newDesignLift
    ? TreeSuggestMultipleV2
    : TreeSuggestMultiple,
  SuggestUsers,
  SuggestAccounts,
});
