import React, { FC, CSSProperties, useContext } from 'react';
import cx from 'classnames';
import { TableHeaderProps } from './TableHeader.types';
import { HeaderCell } from './HeaderCell';
import { HeaderCellWithControls } from './HeaderCellWithControls';
import { CheckboxForSelect } from '../hoc/withEdit/components/CheckboxForSelect';
import themes from './themes';
import { themeContext } from '../themes';

const TableHeader: FC<TableHeaderProps> = ({
  columns,
  gridTemplate,
  withControls = false,
  withSelect = false,
  pinCheckbox = false,
  fieldsSettings,
}) => {
  const theme = useContext(themeContext);
  const css = themes[theme] || themes.default;
  const style: CSSProperties = {
    gridTemplateColumns: gridTemplate,
  };

  const CellComponent = withControls ? HeaderCellWithControls : HeaderCell;

  return (
    <div className={css.TableHeader} style={style}>
      {withSelect && (
        <CheckboxForSelect
          className={cx({
            [css.TableHeader__checkboxCell_sticky]: pinCheckbox,
          })}
        />
      )}
      {columns.map((column) => {
        const className = cx({
          [css.TableHeader__cell_sticky]: fieldsSettings[column.id]?.isPinned ?? column.isPinned,
        });

        return <CellComponent key={column.id} column={column} className={className} />;
      })}
    </div>
  );
};

export default TableHeader;
