import React, { FC } from 'react';
import { withLoad, WithLoadInjectedProps } from 'hoc/withLoad';
import { TableEditable } from '../TableEditable';
import Table from '../Table';
import { TableProps, Table as ITable } from '../Table.types';
import { isEditable } from '../utils/isEditable';

const TableAdapter: FC<WithLoadInjectedProps<ITable> &
  Omit<TableProps, 'tableData'> & {
    showEditPanel?: boolean;
    wrapSelfByContext?: boolean;
    hasModal?: boolean;
  }> = ({ url, data, ...restProps }) => {
  const withEdit = isEditable(data);
  if (withEdit) {
    return <TableEditable baseUrl={url} tableData={data} {...restProps} />;
  }
  return <Table tableData={data} {...restProps} />;
};
export const TableLoadable = withLoad(TableAdapter);
