import React, { FC } from 'react';
import { FixedSizeTree as Tree } from 'react-vtree';
import AutoSizer from 'react-virtualized-auto-sizer';
import { createTreeWalker } from '../utils/treeWalker';
import { ITEM_SIZE } from './FilterTree.contants';
import { FilterTreeProps } from './FilterTree.types';
import { FilterTreeNode } from './FilterTreeNode';
import css from './FilterTree.module.css';

export const FilterTree: FC<FilterTreeProps> = (props) => {
  const treeWalker = createTreeWalker(props.treeRoot);

  return (
    <div className={css.FilterTree}>
      <AutoSizer>
        {({ height, width }) => (
          <Tree itemSize={ITEM_SIZE} treeWalker={treeWalker} width={width} height={height}>
            {FilterTreeNode}
          </Tree>
        )}
      </AutoSizer>
    </div>
  );
};
