import React, { FC, useContext } from 'react';
import { Filter as DesignFilter } from 'components/design/Filter';
import { context } from 'components/Table/services/TableController/TableController.context';
import { FilterProps } from './Filter.types';

export const Filter: FC<FilterProps> = ({ filter, nestingLevel, vTreeStyle, disabled }) => {
  const controller = useContext(context);
  const isSelected = controller.hasTemplateFilter(Number(filter.id));

  const handleClick = () => {
    if (filter.isLeaf) {
      controller
        .toggleTemplateFilter(Number(filter.id))
        .resetCurrentPage()
        .fetch();
    }
  };
  return (
    <DesignFilter
      label={filter.name}
      value={filter.counter}
      isExpanded
      isDisabled={disabled}
      isPressed={isSelected}
      onClick={handleClick}
      canExpand={false}
      depth={nestingLevel}
      style={vTreeStyle}
      showValue={false}
    />
  );
};
