import { CSSProperties } from 'react';
import { FixedSizeNodeComponentProps } from 'react-vtree';
import { TemplateFilter } from '../../TemplateFilters.types';

export interface FilterNode {
  id: string;
  name: string;
  counter: string | number;
  isLeaf: boolean;
  items?: TemplateFilter[];
}

export interface TreeNode {
  id: string;
  isOpenByDefault: boolean;
  defaultHeight: number;
  filter: FilterNode;
  nestingLevel: number;
  style?: CSSProperties;
}

export type FilterTreeNodeProps = FixedSizeNodeComponentProps<TreeNode>;
