import React, { useEffect, FC, useState } from 'react';
import { get } from 'api/common';
import { config } from 'services/Config';
import { FilterTree } from './FilterTree/FilterTree';
import { TemplateFiltersProps, TemplateFilter } from './TemplateFilters.types';
import css from './TemplateFilters.module.css';
import { growTree } from './utils/growTree';
import { TreeViewFilter } from './TreeViewFilter';

export const TemplateFilters: FC<TemplateFiltersProps> = ({ sourceUrl }) => {
  const [filters, setFilters] = useState<TemplateFilter[] | undefined>();

  useEffect(() => {
    let request;
    if (sourceUrl) {
      request = get<TemplateFilter[]>({ url: sourceUrl }).then(setFilters);
    }
    return () => request.cancel();
  }, []);

  if (!filters || filters.length === 0) {
    return null;
  }

  const tree = growTree(filters);

  const filterComponent = config.value.features.newDesignFilters ? (
    <TreeViewFilter treeRoot={tree} />
  ) : (
    <FilterTree treeRoot={tree} />
  );

  return (
    <div className={css.TemplateFilters}>
      <h2 className={css.TemplateFilters__title}>Фильтры</h2>
      {filters.length > 0 ? filterComponent : <div>Нет доступных фильтров</div>}
    </div>
  );
};
