import React, { useContext } from 'react';
import { FilterItem, FilterItemProps } from 'components/TreeView/items/FilterItem';
import { context } from 'components/Table/services/TableController/TableController.context';

export const FilterNode: React.FC<FilterItemProps> = (props) => {
  const { id, isLeaf } = props;
  const controller = useContext(context);
  const isSelected = controller.hasTemplateFilter(Number(id));

  const handleClick = () => {
    if (isLeaf) {
      controller
        .toggleTemplateFilter(Number(props.id))
        .resetCurrentPage()
        .fetch();
    }
  };

  return <FilterItem {...props} isSelected={isSelected} onSelect={handleClick} />;
};
