import React, { useMemo } from 'react';
import { TreeView } from 'components/TreeView';
import { getExpandedIds, treeViewFilterAdapter } from './TreeViewFilter.utils';
import { TreeViewFilterProps } from './TreeViewFilter.types';
import { FilterNode } from './FilterNode';

export const TreeViewFilter: React.FC<TreeViewFilterProps> = ({ treeRoot }) => {
  const items = useMemo(() => treeViewFilterAdapter(treeRoot.items), [treeRoot]);
  const defaultExpanded = useMemo(() => getExpandedIds(items), [items]);

  return <TreeView defaultExpanded={defaultExpanded} ItemComponent={FilterNode} items={items} />;
};
