import { TemplateFilter } from '../TemplateFilters.types';

export const getExpandedIds = (items) => {
  const result: string[] = [];

  items.forEach(({ items, id }) => {
    if (items?.length) {
      result.push(id);
      result.concat(getExpandedIds(items));
    }
  });

  return result;
};

export const getItemData = ({ id, name: label, children, ...other }: TemplateFilter) => {
  return { id, data: { label, ...other }, items: children?.map(getItemData) };
};

export const treeViewFilterAdapter = (items) => items.map(getItemData);
