import memoize from 'memoize-one';
import { TemplateFilter } from '../TemplateFilters.types';
export interface TreeRoot {
  id: 0;
  items: TemplateFilter[];
}

const createTreeWalker = (treeRoot: TreeRoot) => {
  return function* treeWalker(refresh: boolean) {
    const stack = [...treeRoot.items].reverse();

    while (stack.length !== 0) {
      const node = stack.pop();
      if (!node) {
        continue;
      }

      const { name } = node;
      const nestingLevel = node.isGroup ? 1 : 2;
      const isLeaf = !node.isGroup;
      let id = node.id.toString();
      const items = node.children || [];

      yield refresh
        ? {
            defaultHeight: 27,
            isOpenByDefault: false,
            id,
            nestingLevel,
            filter: {
              name,
              id,
              isLeaf,
              items,
              counter: 0,
            },
          }
        : id;

      if (items && items.length !== 0) {
        for (let i = items.length - 1; i >= 0; i--) {
          stack.push(items[i]);
        }
      }
    }
  };
};

const memoized = memoize(createTreeWalker);

export { memoized as createTreeWalker };
