import React, { FC } from 'react';
import cx from 'classnames';
import { Text as LegoText } from '@crm/components/dist/lego2/Text';
import { TextProps } from './Text.types';
import css from './Text.module.css';
import { ExpandText } from '../../ExpandText';

export const Text: FC<TextProps> = (props) => {
  const { value, bold, color = 'primary' } = props.text;

  const className = cx(props.className, css.Text, {
    [css.Text_bold]: bold,
  });

  if (props.withExpand) {
    return <ExpandText {...props} className={className} />;
  }

  return (
    <LegoText color={color} className={className}>
      {value}
    </LegoText>
  );
};
