import React, { createContext, useContext, FC, useState } from 'react';
import { WithEditService } from './withEdit.service';

export const context = createContext<WithEditService>(new WithEditService());

export const Provider = context.Provider;
export const Consumer = context.Consumer;
export const useEditingService = () => useContext(context);

export const StatefulProvider: FC<{
  baseUrl?: string;
}> = ({ baseUrl, children }) => {
  const [service] = useState(() => new WithEditService(baseUrl));

  return <Provider value={service}>{children}</Provider>;
};
