import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import cx from 'classnames';
import CheckboxComponent from '@crm/components/dist/lego2/Checkbox';
import { useEditingService } from '../../EditingContext';
import { CheckboxForSelectProps } from './CheckboxForSelect.types';
import css from './CheckboxForSelect.module.css';

export const CheckboxForSelect: FC<CheckboxForSelectProps> = observer(({ id, className }) => {
  const service = useEditingService();
  const isChecked = id ? service.selectedRows?.has(String(id)) : service.isAllRowsSelected();
  const handleCheck = () => {
    if (id) {
      service.toggleSelectRow(id);
      return;
    }
    if (service.isAllRowsSelected()) {
      service.unselectAllRows();
      return;
    }
    service.selectAllRows();
  };

  return (
    <div className={cx(className, css.CheckboxForSelect)}>
      <CheckboxComponent view="outline" size="m" checked={isChecked} onChange={handleCheck} />
    </div>
  );
});
