import React, { FC } from 'react';
import { withOverlay } from 'components/Overlay';
import LegoButton, { ButtonProps } from '@crm/components/dist/lego2/Button';
import { ActionButtonProps } from './ActionButton.types';

const Button = withOverlay('loading')<ButtonProps & { loading?: boolean }>(LegoButton, {
  hasSpinner: true,
  zIndex: 10,
  size: 'xxs',
});

const buttonViewByTheme = {
  clean: 'pseudo',
};

export const ActionButton: FC<ActionButtonProps> = ({
  action,
  disabled = false,
  theme,
  isLoading = false,
  onClick,
}) => {
  const handleActionButtonClick = () => {
    onClick(action.id);
  };
  return (
    <Button
      disabled={disabled}
      onClick={handleActionButtonClick}
      loading={isLoading}
      view={buttonViewByTheme[theme] || 'default'}
    >
      {action.caption}
    </Button>
  );
};
