import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { AddButtonProps } from './AddButton.types';

const buttonViewByTheme = {
  clean: 'pseudo',
};

export const AddButton: FC<AddButtonProps> = ({ disabled = false, theme, onClick }) => {
  return (
    <Button
      data-testid="addRowButton"
      disabled={disabled}
      onClick={onClick}
      view={buttonViewByTheme[theme] || 'default'}
    >
      Добавить строку
    </Button>
  );
};
