import React, { FC, useContext } from 'react';
import { observer } from 'mobx-react-lite';
import Access from 'utils/Access';
import { themeContext } from '../../../../themes';
import css from './EditPanel.module.css';
import { useEditingService } from '../../EditingContext';
import { ActionButton } from './ActionButton';
// Увезти отсюда когда переведем все гриды на новые экшены
import { AddButton } from './AddButton';

export const EditPanel: FC = observer(() => {
  const service = useEditingService();
  const { actionsManager } = service;
  const theme = useContext(themeContext);

  const handleAddButtonClick = () => {
    service.addRow();
  };

  const handleActionButtonClick = (id: string) => () => {
    actionsManager.doAction(id);
  };
  const isBulkActionDisabled = !service.selectedRows || service.selectedRows?.size === 0;
  const tableMeta = service.stateManager.getTableMeta();
  return (
    <div className={css.EditPanel}>
      {tableMeta?.createAction && (
        <AddButton
          disabled={!Access.isEdit(service.permissions?.add?.access)}
          onClick={handleAddButtonClick}
          theme={theme}
        />
      )}
      {actionsManager.actions &&
        actionsManager.actions.map((action) => {
          if (action.mode === 'Row') {
            return null;
          }
          const isDisabled =
            Boolean(action.mode === 'Bulk' && isBulkActionDisabled) ||
            Boolean(actionsManager.actionInProgress);
          return (
            <ActionButton
              disabled={isDisabled}
              key={action.id}
              action={action}
              onClick={handleActionButtonClick(action.id)}
              isLoading={Boolean(actionsManager.actionInProgress === action)}
              theme={theme}
            >
              {action.caption}
            </ActionButton>
          );
        })}
    </div>
  );
});
