import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Modal from '@crm/components/dist/lego2/Modal';
import { useEditingService } from '../../EditingContext';
import { editingReportAdapter } from './adapter';
import { UnknownTypeReport } from './UnknownTypeReport';

export const EditingReport: FC = observer(() => {
  const service = useEditingService();
  const { editingReport, clearEditingReport } = service;

  if (!editingReport) {
    return null;
  }

  const ReportComponent = editingReportAdapter[editingReport.type] || UnknownTypeReport;

  return (
    <Modal
      visible={Boolean(editingReport)}
      theme="normal"
      onClose={clearEditingReport}
      hasAnimation={false}
    >
      <ReportComponent report={editingReport} />
    </Modal>
  );
});
