import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import { DtsLiftReportProps } from './DtsLiftReport.types';
import css from './DtsLiftReport.module.css';
import { SUCCESS_COUNT_CAPTION, ERROR_COUNT_CAPTION } from './DtsLiftReport.constants';

export const DtsLiftReport: FC<DtsLiftReportProps> = ({ report }) => {
  const successItems = report.data?.filter((row) => row.isSuccess);
  const errorItems = report.data?.filter((row) => row.isSuccess === false);

  return (
    <div className={css.Report}>
      <h2 className={css.Report__title}>Результат</h2>
      <p>
        <Icon svg="check2" size="l" className={cx(css.Report__icon, css.Report__icon_success)} />
        {SUCCESS_COUNT_CAPTION}
        {successItems?.length || 0}
      </p>
      {errorItems?.length > 0 && (
        <>
          <p>
            <Icon svg="error" size="l" className={cx(css.Report__icon, css.Report__icon_error)} />
            {ERROR_COUNT_CAPTION}
            {errorItems.length}
          </p>
          <table className={css.Report__detailsTable}>
            <thead>
              <tr>
                <th>ID</th>
                <th>Причина</th>
              </tr>
            </thead>
            <tbody>
              {errorItems.map((row) => (
                <tr key={row.id}>
                  <td>{row.id}</td>
                  <td>{row.message}</td>
                </tr>
              ))}
            </tbody>
          </table>
        </>
      )}
    </div>
  );
};
