import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Modal from '@crm/components/dist/lego2/Modal';
import { Overlay } from 'components/Overlay';
import css from './ModalForm.module.css';
import { useEditingService } from '../../EditingContext';
import { ModalFormProps } from './ModalForm.types';

export const ModalForm: FC<ModalFormProps> = observer(({ editingService }) => {
  // TODO: костыляка из-за продлемы с импортом https://st.yandex-team.ru/CRM-12770
  const { FormByScheme } = require('components/FormByScheme/FormByScheme');
  const service = editingService || useEditingService();
  const {
    editingForm,
    clearEditingForm,
    submitForm,
    formTitle,
    actionsManager,
    fieldChangeHandler,
  } = service;

  if (!editingForm) {
    return null;
  }

  let title = editingForm.data[0].id ? 'Редактирование строки' : 'Добавление строки';
  if (formTitle) {
    title = formTitle;
  }

  const submitAction = actionsManager.currentAction ? actionsManager.submitActionForm : submitForm;
  const handleCloseForm = () => {
    if (!actionsManager.currentAction) {
      clearEditingForm();
    } else {
      actionsManager.cancelAction();
    }
  };
  const handleSubmitSuccess = () => {
    !actionsManager.currentAction && clearEditingForm();
  };
  return (
    <Modal
      visible={Boolean(editingForm || actionsManager.actionInProgress)}
      theme="normal"
      onClose={handleCloseForm}
      hasAnimation={false}
      title={title}
      limitHeight
    >
      <Overlay
        display={Boolean(actionsManager.actionInProgress)}
        hasSpinner
        zIndex={10}
        color="rgba(255,255,255,.9)"
      />
      {editingForm && (
        <div className={css.b}>
          <FormByScheme
            onSubmitSuccess={handleSubmitSuccess}
            scheme={editingForm}
            onSubmit={submitAction}
            onChange={fieldChangeHandler}
          />
        </div>
      )}
    </Modal>
  );
});
