import { Table } from '../../../Table.types';

const invalidTypes = ['List'];

export const prepareRowToFormData = (editData): Table => {
  const table = { ...editData, meta: { ...editData.meta } };
  table.meta.fields = table.meta.fields.filter((field) => {
    if (invalidTypes.includes(field.type)) {
      table.meta.fieldsVisibility = table.meta.fieldsVisibility.filter((id) => id !== field.id);
      return false;
    }
    return true;
  });
  return table;
};
